<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include database and auth class
require_once '../config/Database.php';
require_once '../middleware/Auth.php';

// Initialize database
$database = new Database();
$db = $database->getConnection();

// Initialize Auth
$auth = new Auth($db);

// Get token from GET parameter for testing
$token = isset($_GET['token']) ? $_GET['token'] : '';

echo "<h1>Token Test Utility</h1>";

if (empty($token)) {
    echo "<p>No token provided. Use ?token=yourTokenHere in the URL.</p>";
    exit;
}

// Check if token exists in database
$exists = $auth->tokenExists($token);
echo "<p>Token exists in database: " . ($exists ? "YES" : "NO") . "</p>";

// Try to validate token
$user = $auth->validateToken($token);

if ($user) {
    echo "<h2>Token is valid!</h2>";
    echo "<p>User details:</p>";
    echo "<pre>";
    print_r($user);
    echo "</pre>";
} else {
    echo "<h2>Token validation failed</h2>";
    echo "<p>The token was not recognized or is invalid.</p>";
}

// For debugging - show all users with tokens (be careful with this in production)
echo "<h2>Users with tokens in database:</h2>";
try {
    $query = "SELECT id, username, email, SUBSTRING(remember_token, 1, 10) as token_preview FROM users WHERE remember_token IS NOT NULL";
    $stmt = $db->prepare($query);
    $stmt->execute();
    
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Token (first 10 chars)</th></tr>";
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . $row['username'] . "</td>";
        echo "<td>" . $row['email'] . "</td>";
        echo "<td>" . $row['token_preview'] . "...</td>";
        echo "</tr>";
    }
    
    echo "</table>";
} catch (PDOException $e) {
    echo "<p>Database error: " . $e->getMessage() . "</p>";
}
?>