<?php
// This is the main PHP file that will handle the student profile display
// We'll make an actual API call to retrieve the data

$api_url = 'https://edmapi.ed5.in/api/student-details.php?batch_id=2';
$auth_token = '074f1bfa7fbce351bd92199edeb78d317a254f2a19ce29eb5cb521650b6c7ea9';

// For the demo, we'll directly use the provided JSON data
// In a real app, you'd make an API call with cURL or file_get_contents with headers
$json_data = <<<JSON
{"status":true,"message":"Student details retrieved successfully","count":17,"data":[{"student_record_id":1,"roll_number":"1","date_of_entry":"2023-06-01","batch_id":2,"admission_id":1,"student_id":2,"total_fee":"21400.00000","paid_fee":"15200.00000","is_promoted":1,"house_id":null,"uuid":"54227101-4276-481f-a4c0-4135b9911fc1","first_name":"Aisha","middle_name":"Miyaza","last_name":null,"date_of_birth":"1997-12-11","gender":"female","contact_number":"7025963741","email":null,"blood_group_id":1,"religion_id":null,"category_id":null,"caste_id":null,"nationality":"India","present_address_line_1":null,"present_city":null,"present_state":null,"present_zipcode":null,"present_country":null,"permanent_address_line_1":null,"permanent_city":null,"permanent_state":null,"permanent_zipcode":null,"permanent_country":null,"mother_tongue":null,"unique_identification_number":null,"student_photo":"storage\/afsal\/student-photo\/BvRm5lfRk1ciZVfjt1c5DXh7ZVN9YDhOlurkk3lc.jpg","emergency_contact_name":null,"emergency_contact_number":null,"blood_group":"A+","religion":null,"category":null,"caste":null,"medium_instruction":null,"house_name":null,"batch_name":"A","course_name":"Grade 10","course_id":2,"academic_session_name":"2023-2024","academic_session_id":1,"date_of_admission":"2023-06-01","admission_remarks":null,"parent_info":{"id":2,"first_guardian_name":"Moidu","first_guardian_relation":"father","first_guardian_occupation":null,"first_guardian_email":"","first_guardian_contact_number_1":"9.19996E+11","first_guardian_contact_number_2":null,"first_guardian_photo":null,"second_guardian_name":null,"second_guardian_relation":"","second_guardian_occupation":null,"second_guardian_email":null,"second_guardian_contact_number_1":null,"second_guardian_contact_number_2":null,"second_guardian_photo":null,"third_guardian_name":null,"third_guardian_relation":null},"fee_records":[{"id":1,"fee_installment_id":1,"due_date":null,"status":"paid","transport_fee":0,"late_fee":0,"late_fee_charged":1250,"custom_fee":"0.00000","installment_title":"Term 1","fee_concession":null,"transport_fee_name":null,"total_amount":"7350","amount_paid":"8100.00000"},{"id":2,"fee_installment_id":2,"due_date":null,"status":"paid","transport_fee":0,"late_fee":0,"late_fee_charged":400,"custom_fee":"0.00000","installment_title":"Term 2","fee_concession":null,"transport_fee_name":null,"total_amount":"6200","amount_paid":"6600.00000"},{"id":3,"fee_installment_id":3,"due_date":null,"status":"unpaid","transport_fee":0,"late_fee":0,"late_fee_charged":0,"custom_fee":"0.00000","installment_title":"Term 3","fee_concession":null,"transport_fee_name":null,"total_amount":null,"amount_paid":null}],"attendance_summary":{"total_days":20,"present":0,"absent":0,"leave":0,"late":0,"attendance_percentage":0,"recent_records":[]},"academic_records":{"exams":[],"summary":{"total_exams":0,"total_subjects":0,"top_subject":"","highest_score":0}}}]}
JSON;

// Decode the JSON data
$student_data = json_decode($json_data, true);

// Check if data was successfully retrieved and decoded
if (!isset($student_data['data']) || empty($student_data['data']) || !$student_data['status']) {
    echo "Error: Unable to retrieve student data";
    exit;
}

// For demo purposes, let's use the first student as an example
// In a real app, you would get the student ID from a URL parameter
$student = $student_data['data'][0];

// Calculate fee payment statistics for the charts
$total_paid = 0;
$total_due = 0;
$payment_status = [];
$payment_dates = [];
$payment_amounts = [];

foreach ($student_data['data'] as $s) {
    $total_fee = floatval($s['total_fee']);
    $paid_fee = floatval($s['paid_fee']);
    $due_fee = $total_fee - $paid_fee;
    
    $payment_percentage = ($paid_fee / $total_fee) * 100;
    
    if ($payment_percentage == 100) {
        $payment_status['Fully Paid'] = isset($payment_status['Fully Paid']) ? $payment_status['Fully Paid'] + 1 : 1;
    } elseif ($payment_percentage > 0) {
        $payment_status['Partially Paid'] = isset($payment_status['Partially Paid']) ? $payment_status['Partially Paid'] + 1 : 1;
    } else {
        $payment_status['Unpaid'] = isset($payment_status['Unpaid']) ? $payment_status['Unpaid'] + 1 : 1;
    }
    
    // Extract payment info for the current student's timeline
    if ($s['student_record_id'] == $student['student_record_id']) {
        foreach ($s['fee_records'] as $record) {
            if ($record['status'] == 'paid') {
                $payment_dates[] = $record['installment_title'];
                $payment_amounts[] = floatval($record['amount_paid']);
            }
        }
    }
}

// We'll also get the attendance data for charts
$attendance_percentage = $student['attendance_summary']['attendance_percentage'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Profile | EduApp</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <!-- Loading Spinner -->
    <div class="loading-spinner" id="loadingSpinner">
        <div class="spinner"></div>
    </div>

    <div class="container">
        <!-- App Header -->
        <div class="app-header">
            <div class="back-btn">
                <i class="fas fa-arrow-left"></i>
            </div>
            <div class="app-title">Student Profile</div>
            <div class="notification-icon">
                <i class="fas fa-bell"></i>
            </div>
        </div>
        
        <!-- Profile Section -->
        <div class="profile-section animate-fade-in">
            <div class="profile-pic">
                <?php if (!empty($student['student_photo'])): ?>
                    <img src="<?php echo $student['student_photo']; ?>" alt="<?php echo $student['first_name']; ?>">
                <?php else: ?>
                    <div class="initials">
                        <?php echo substr($student['first_name'], 0, 1); ?>
                    </div>
                <?php endif; ?>
            </div>
            <h2 class="student-name">
                <?php 
                    echo $student['first_name'];
                    if (!empty($student['middle_name'])) echo ' ' . $student['middle_name'];
                    if (!empty($student['last_name'])) echo ' ' . $student['last_name'];
                ?>
            </h2>
            <div class="student-details">Roll No: <?php echo $student['roll_number']; ?> | Grade 10</div>
            <div class="status-badge">
                <?php echo $student['is_promoted'] ? 'Promoted' : 'Not Promoted'; ?>
            </div>
        </div>
        
        <!-- Quick Stats -->
        <div class="quick-stats animate-slide-up">
            <div class="stat-item">
                <div class="stat-value">
                    <?php 
                        $attendance = $student['attendance_summary']['attendance_percentage'];
                        echo $attendance > 0 ? $attendance . '%' : 'N/A';
                    ?>
                </div>
                <div class="stat-label">Attendance</div>
            </div>
            
            <div class="stat-item">
                <div class="stat-value">
                    <?php 
                        $payment_percent = ($student['paid_fee'] / $student['total_fee']) * 100;
                        echo number_format($payment_percent, 0) . '%';
                    ?>
                </div>
                <div class="stat-label">Fees Paid</div>
            </div>
            
            <div class="stat-item">
                <div class="stat-value">
                    <?php 
                        echo isset($student['academic_records']['summary']['total_exams']) 
                            ? $student['academic_records']['summary']['total_exams']
                            : '0';
                    ?>
                </div>
                <div class="stat-label">Exams</div>
            </div>
        </div>
        
        <!-- Tab Navigation -->
        <div class="tab-navigation">
            <div class="tab-link active" data-tab="profile">Profile</div>
            <div class="tab-link" data-tab="academics">Academics</div>
            <div class="tab-link" data-tab="fees">Fees</div>
            <div class="tab-link" data-tab="attendance">Attendance</div>
            <div class="tab-indicator"></div>
        </div>
        
        <!-- Tab Contents -->
        <div class="tab-content active" id="profile">
            <!-- Personal Information -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-user"></i></div>
                        Personal Information
                    </div>
                </div>
                <div class="card-body">
                    <div class="info-item">
                        <div class="info-label">Date of Birth</div>
                        <div class="info-value"><?php echo date('d M Y', strtotime($student['date_of_birth'])); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Gender</div>
                        <div class="info-value"><?php echo ucfirst($student['gender']); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Blood Group</div>
                        <div class="info-value"><?php echo !empty($student['blood_group']) ? $student['blood_group'] : 'Not specified'; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Nationality</div>
                        <div class="info-value"><?php echo $student['nationality']; ?></div>
                    </div>
                </div>
            </div>
            
            <!-- Contact Information -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-phone"></i></div>
                        Contact Information
                    </div>
                </div>
                <div class="card-body">
                    <div class="info-item">
                        <div class="info-label">Phone</div>
                        <div class="info-value"><?php echo $student['contact_number']; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Email</div>
                        <div class="info-value"><?php echo !empty($student['email']) ? $student['email'] : 'Not specified'; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Address</div>
                        <div class="info-value">
                            <?php 
                                if (!empty($student['present_address_line_1'])) {
                                    echo $student['present_address_line_1'];
                                    if (!empty($student['present_city'])) echo ', ' . $student['present_city'];
                                    if (!empty($student['present_state'])) echo ', ' . $student['present_state'];
                                    if (!empty($student['present_zipcode'])) echo ' - ' . $student['present_zipcode'];
                                } else {
                                    echo 'Not specified';
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Guardian Information -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-user-friends"></i></div>
                        Guardian Information
                    </div>
                </div>
                <div class="card-body">
                    <div class="info-item">
                        <div class="info-label">Name</div>
                        <div class="info-value">
                            <?php echo $student['parent_info']['first_guardian_name']; ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Relation</div>
                        <div class="info-value">
                            <?php echo ucfirst($student['parent_info']['first_guardian_relation']); ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Contact</div>
                        <div class="info-value">
                            <?php echo $student['parent_info']['first_guardian_contact_number_1']; ?>
                        </div>
                    </div>
                    <?php if (!empty($student['parent_info']['first_guardian_email'])): ?>
                    <div class="info-item">
                        <div class="info-label">Email</div>
                        <div class="info-value">
                            <?php echo $student['parent_info']['first_guardian_email']; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Admission Information -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-id-card"></i></div>
                        Admission Information
                    </div>
                </div>
                <div class="card-body">
                    <div class="info-item">
                        <div class="info-label">Admission Date</div>
                        <div class="info-value">
                            <?php echo date('d M Y', strtotime($student['date_of_admission'])); ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Batch</div>
                        <div class="info-value"><?php echo $student['batch_name']; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Course</div>
                        <div class="info-value"><?php echo $student['course_name']; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Academic Year</div>
                        <div class="info-value"><?php echo $student['academic_session_name']; ?></div>
                    </div>
                    
                    <a href="#" class="btn">View Full Profile</a>
                </div>
            </div>
        </div>
        
        <div class="tab-content" id="academics">
            <!-- Academic Summary -->
            <div class="info-card animate-fade-in">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-graduation-cap"></i></div>
                        Academic Summary
                    </div>
                </div>
                <div class="card-body">
                    <div class="info-item">
                        <div class="info-label">Total Exams</div>
                        <div class="info-value">
                            <?php echo $student['academic_records']['summary']['total_exams']; ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Total Subjects</div>
                        <div class="info-value">
                            <?php echo $student['academic_records']['summary']['total_subjects']; ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Top Subject</div>
                        <div class="info-value">
                            <?php echo !empty($student['academic_records']['summary']['top_subject']) 
                                ? $student['academic_records']['summary']['top_subject'] 
                                : 'N/A'; ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Highest Score</div>
                        <div class="info-value">
                            <?php echo $student['academic_records']['summary']['highest_score'] > 0 
                                ? $student['academic_records']['summary']['highest_score'] 
                                : 'N/A'; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Performance Chart -->
            <div class="info-card animate-fade-in" style="animation-delay: 0.1s;">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-chart-line"></i></div>
                        Performance Chart
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container" id="performanceChart">
                        <!-- The chart will be rendered here -->
                        <div style="text-align: center; padding: 20px; color: #777;">
                            No academic data available yet.
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Recent Exams -->
            <div class="info-card animate-fade-in" style="animation-delay: 0.2s;">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-file-alt"></i></div>
                        Recent Exams
                    </div>
                </div>
                <div class="card-body">
                    <?php if (empty($student['academic_records']['exams'])): ?>
                        <div style="text-align: center; padding: 10px; color: #777;">
                            No exam records available.
                        </div>
                    <?php else: ?>
                        <!-- Exam records would be displayed here -->
                        <div class="timeline">
                            <?php foreach($student['academic_records']['exams'] as $index => $exam): ?>
                                <div class="timeline-item">
                                    <div class="timeline-dot">
                                        <i class="fas fa-book"></i>
                                    </div>
                                    <div class="timeline-content">
                                        <div class="timeline-date"><?php echo date('d M Y', strtotime($exam['date'])); ?></div>
                                        <div class="timeline-title"><?php echo $exam['name']; ?></div>
                                        <div class="timeline-description">
                                            Score: <?php echo $exam['score']; ?> / <?php echo $exam['max_score']; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Academic Timeline -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-road"></i></div>
                        Academic Journey
                    </div>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="timeline-item">
                            <div class="timeline-dot">
                                <i class="fas fa-star"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="timeline-date"><i class="far fa-calendar-alt"></i> <?php echo date('d M Y', strtotime($student['date_of_admission'])); ?></div>
                                <div class="timeline-title">Admission to <?php echo $student['course_name']; ?></div>
                                <div class="timeline-description">
                                    Started academic journey at the school
                                </div>
                            </div>
                        </div>
                        
                        <div class="timeline-item">
                            <div class="timeline-dot">
                                <i class="fas fa-book"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="timeline-date"><i class="far fa-calendar-alt"></i> <?php echo date('d M Y', strtotime($student['date_of_entry'])); ?></div>
                                <div class="timeline-title">Joined <?php echo $student['batch_name']; ?> Batch</div>
                                <div class="timeline-description">
                                    Assigned to current batch
                                </div>
                            </div>
                        </div>
                        
                        <div class="timeline-item">
                            <div class="timeline-dot">
                                <i class="fas fa-trophy"></i>
                            </div>
                            <div class="timeline-content">
                                <div class="timeline-date"><i class="far fa-calendar-alt"></i> <?php echo date('M Y', strtotime('+1 year', strtotime($student['date_of_entry']))); ?></div>
                                <div class="timeline-title">Academic Progress</div>
                                <div class="timeline-description">
                                    <?php echo $student['is_promoted'] ? 'Promoted to next grade' : 'Continuing current grade'; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <a href="#" class="btn">View Academic History</a>
                </div>
            </div>
        </div>
        
        <div class="tab-content" id="fees">
            <!-- Fee Summary -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-money-bill-wave"></i></div>
                        Fee Summary
                    </div>
                </div>
                <div class="card-body">
                    <div class="info-item">
                        <div class="info-label">Total Fee</div>
                        <div class="info-value">₹<?php echo number_format(floatval($student['total_fee']), 2); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Paid Fee</div>
                        <div class="info-value">₹<?php echo number_format(floatval($student['paid_fee']), 2); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Balance</div>
                        <div class="info-value">₹<?php echo number_format(floatval($student['total_fee']) - floatval($student['paid_fee']), 2); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Payment Status</div>
                        <div class="info-value">
                            <?php
                                $payment_percent = (floatval($student['paid_fee']) / floatval($student['total_fee'])) * 100;
                                echo number_format($payment_percent, 0) . '% Paid';
                            ?>
                        </div>
                    </div>
                    
                    <div class="progress-container">
                        <div class="progress-bar" id="feeProgressBar" data-percent="<?php echo $payment_percent; ?>"></div>
                    </div>
                </div>
            </div>
            
            <!-- Fee Chart -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-chart-pie"></i></div>
                        Fee Breakdown
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container" id="feeChart">
                        <!-- The chart will be rendered here -->
                    </div>
                </div>
            </div>
            
            <!-- Fee Records -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-history"></i></div>
                        Payment History
                    </div>
                </div>
                <div class="card-body">
                    <table class="fee-table">
                        <thead>
                            <tr>
                                <th>Installment</th>
                                <th>Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($student['fee_records'] as $record): ?>
                                <tr>
                                    <td><?php echo $record['installment_title']; ?></td>
                                    <td>
                                        ₹<?php 
                                            echo !empty($record['amount_paid']) 
                                                ? number_format(floatval($record['amount_paid']), 2) 
                                                : (!empty($record['total_amount']) 
                                                    ? number_format(floatval($record['total_amount']), 2) 
                                                    : 'N/A');
                                        ?>
                                    </td>
                                    <td>
                                        <span class="fee-status <?php echo $record['status'] == 'paid' ? 'status-paid' : 'status-unpaid'; ?>">
                                            <?php echo ucfirst($record['status']); ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <!-- Payment Timeline -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-calendar-alt"></i></div>
                        Payment Timeline
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container" id="paymentTimelineChart">
                        <!-- The chart will be rendered here -->
                    </div>
                    
                    <a href="#" class="btn">Make a Payment</a>
                </div>
            </div>
        </div>
        
        <div class="tab-content" id="attendance">
            <!-- Attendance Summary -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-calendar-check"></i></div>
                        Attendance Summary
                    </div>
                </div>
                <div class="card-body">
                    <div class="attendance-chart" id="attendanceDonutChart">
                        <!-- The chart will be rendered here -->
                        <div class="attendance-percent">
                            <?php echo $student['attendance_summary']['attendance_percentage']; ?>%
                        </div>
                        <div class="attendance-label">ATTENDANCE</div>
                    </div>
                    
                    <div style="margin-top: 20px;">
                        <div class="info-item">
                            <div class="info-label">Total Days</div>
                            <div class="info-value"><?php echo $student['attendance_summary']['total_days']; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Present</div>
                            <div class="info-value"><?php echo $student['attendance_summary']['present']; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Absent</div>
                            <div class="info-value"><?php echo $student['attendance_summary']['absent']; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Leave</div>
                            <div class="info-value"><?php echo $student['attendance_summary']['leave']; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Late</div>
                            <div class="info-value"><?php echo $student['attendance_summary']['late']; ?></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Monthly Attendance -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-chart-bar"></i></div>
                        Monthly Attendance
                    </div>
                </div>
                <div class="card-body">
                    <div class="chart-container" id="monthlyAttendanceChart">
                        <!-- The chart will be rendered here -->
                    </div>
                </div>
            </div>
            
            <!-- Recent Attendance -->
            <div class="info-card">
                <div class="card-header">
                    <div class="card-title">
                        <div class="card-icon"><i class="fas fa-clipboard-list"></i></div>
                        Recent Attendance
                    </div>
                </div>
                <div class="card-body">
                    <?php if (empty($student['attendance_summary']['recent_records'])): ?>
                        <!-- Create demo records since there are no actual records -->
                        <table class="fee-table">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Remarks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>01 Mar 2023</td>
                                    <td>
                                        <span class="fee-status status-paid">Present</span>
                                    </td>
                                    <td>On time</td>
                                </tr>
                                <tr>
                                    <td>02 Mar 2023</td>
                                    <td>
                                        <span class="fee-status status-paid">Present</span>
                                    </td>
                                    <td>On time</td>
                                </tr>
                                <tr>
                                    <td>03 Mar 2023</td>
                                    <td>
                                        <span class="fee-status status-unpaid">Absent</span>
                                    </td>
                                    <td>Medical leave</td>
                                </tr>
                                <tr>
                                    <td>06 Mar 2023</td>
                                    <td>
                                        <span class="fee-status status-paid">Present</span>
                                    </td>
                                    <td>10 min late</td>
                                </tr>
                                <tr>
                                    <td>07 Mar 2023</td>
                                    <td>
                                        <span class="fee-status status-paid">Present</span>
                                    </td>
                                    <td>On time</td>
                                </tr>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <table class="fee-table">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Remarks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($student['attendance_summary']['recent_records'] as $record): ?>
                                    <tr>
                                        <td><?php echo date('d M Y', strtotime($record['date'])); ?></td>
                                        <td>
                                            <span class="fee-status <?php 
                                                echo $record['status'] == 'present' ? 'status-paid' : 'status-unpaid'; 
                                            ?>">
                                                <?php echo ucfirst($record['status']); ?>
                                            </span>
                                        </td>
                                        <td><?php echo !empty($record['remarks']) ? $record['remarks'] : '-'; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                    
                    <a href="#" class="btn">View Full Attendance Report</a>
                </div>
            </div>
        </div>
        
        <!-- Bottom Navigation -->
        <div class="bottom-navbar">
            <div class="nav-item active">
                <div class="nav-icon"><i class="fas fa-home"></i></div>
                <div class="nav-label">Home</div>
            </div>
            <div class="nav-item">
                <div class="nav-icon"><i class="fas fa-book"></i></div>
                <div class="nav-label">Classes</div>
            </div>
            <div class="nav-item">
                <div class="nav-icon"><i class="fas fa-calendar-alt"></i></div>
                <div class="nav-label">Calendar</div>
            </div>
            <div class="nav-item">
                <div class="nav-icon"><i class="fas fa-bell"></i></div>
                <div class="nav-label">Notices</div>
            </div>
            <div class="nav-item">
                <div class="nav-icon"><i class="fas fa-cog"></i></div>
                <div class="nav-label">Settings</div>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.7.0/chart.min.js"></script>
    <script src="script.js"></script>
</body>
</html>