<?php
class User {
    private $conn;
    private $table_name = "users";

    public $id;
    public $email;
    public $username;
    public $password;
    public $status;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function login($username, $password) {
        $query = "SELECT id, email, username, password, status 
                 FROM " . $this->table_name . " 
                 WHERE (email = :username OR username = :username)
                 AND status = 'activated'";

        $stmt = $this->conn->prepare($query);
        
        // Sanitize input
        $username = htmlspecialchars(strip_tags($username));
        
        // Bind parameters
        $stmt->bindParam(":username", $username);
        
        $stmt->execute();
        
        if($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // Verify password
            if(password_verify($password, $row['password'])) {
                // Generate token
                $token = $this->generateToken($row['id']);
                
                return array(
                    "status" => true,
                    "data" => array(
                        "token" => $token,
                        "user" => array(
                            "id" => $row['id'],
                            "email" => $row['email'],
                            "username" => $row['username']
                        )
                    )
                );
            }
        }
        
        return array(
            "status" => false,
            "message" => "Invalid credentials"
        );
    }

    private function generateToken($user_id) {
        // Generate a random token
        $token = bin2hex(random_bytes(32));
        
        // Store token in database (you might want to create a separate tokens table)
        $query = "UPDATE " . $this->table_name . "
                 SET remember_token = :token
                 WHERE id = :user_id";
        
        $stmt = $this->conn->prepare($query);
        
        $stmt->bindParam(":token", $token);
        $stmt->bindParam(":user_id", $user_id);
        
        $stmt->execute();
        
        return $token;
    }

    public function getUserRoles($user_id) {
        $query = "SELECT r.name 
                 FROM roles r 
                 JOIN model_has_roles mhr ON r.id = mhr.role_id 
                 WHERE mhr.model_id = :user_id";
                 
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":user_id", $user_id);
        $stmt->execute();
        
        return $stmt->fetchAll(PDO::FETCH_COLUMN);
    }
}
?>