<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Management System</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #6B73FF 0%, #000DFF 100%);
            min-height: 100vh;
        }
        
        .login-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 24px;
            backdrop-filter: blur(10px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            transform: translateY(20px);
            opacity: 0;
            animation: slideUp 0.6s ease forwards;
        }
        
        .input-group {
            position: relative;
            margin-bottom: 25px;
        }
        
        .input-group input {
            width: 100%;
            padding: 15px 15px;
            border: 2px solid #e1e1e1;
            border-radius: 12px;
            font-size: 16px;
            background: transparent;
            transition: all 0.3s ease;
        }
        
        .input-group input:focus {
            border-color: #4F46E5;
            box-shadow: 0 0 0 4px rgba(79, 70, 229, 0.1);
        }
        
        .input-group label {
            position: absolute;
            left: 15px;
            top: 15px;
            font-size: 16px;
            color: #6B7280;
            pointer-events: none;
            transition: all 0.3s ease;
        }
        
        .input-group input:focus + label,
        .input-group input:not(:placeholder-shown) + label {
            transform: translateY(-25px);
            font-size: 14px;
            color: #4F46E5;
            background: #fff;
            padding: 0 5px;
        }
        
        .login-btn {
            background: linear-gradient(135deg, #6366F1 0%, #4F46E5 100%);
            color: white;
            border: none;
            border-radius: 12px;
            padding: 15px;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(79, 70, 229, 0.4);
            transform: translateY(0);
        }
        
        .login-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(79, 70, 229, 0.6);
        }
        
        .login-btn:active {
            transform: translateY(0);
        }
        
        .school-icon {
            animation: float 3s ease-in-out infinite;
        }
        
        @keyframes slideUp {
            0% {
                transform: translateY(50px);
                opacity: 0;
            }
            100% {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        @keyframes float {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-15px);
            }
        }
        
        .bg-bubbles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            overflow: hidden;
        }
        
        .bubble {
            position: absolute;
            bottom: -100px;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 50%;
            animation: rise 15s infinite ease-in;
            opacity: 0;
        }
        
        .bubble:nth-child(1) {
            width: 60px;
            height: 60px;
            left: 10%;
            animation-duration: 12s;
        }
        
        .bubble:nth-child(2) {
            width: 30px;
            height: 30px;
            left: 20%;
            animation-duration: 16s;
            animation-delay: 1s;
        }
        
        .bubble:nth-child(3) {
            width: 50px;
            height: 50px;
            left: 35%;
            animation-duration: 13s;
            animation-delay: 2s;
        }
        
        .bubble:nth-child(4) {
            width: 80px;
            height: 80px;
            left: 50%;
            animation-duration: 17s;
            animation-delay: 3s;
        }
        
        .bubble:nth-child(5) {
            width: 35px;
            height: 35px;
            left: 65%;
            animation-duration: 14s;
            animation-delay: 4s;
        }
        
        .bubble:nth-child(6) {
            width: 45px;
            height: 45px;
            left: 80%;
            animation-duration: 15s;
            animation-delay: 5s;
        }
        
        .bubble:nth-child(7) {
            width: 70px;
            height: 70px;
            left: 90%;
            animation-duration: 18s;
            animation-delay: 6s;
        }
        
        @keyframes rise {
            0% {
                bottom: -100px;
                opacity: 0;
            }
            5% {
                opacity: 0.8;
            }
            95% {
                opacity: 0.8;
            }
            100% {
                bottom: 100%;
                opacity: 0;
            }
        }
    </style>
</head>
<body>
    <div class="bg-bubbles">
        <div class="bubble"></div>
        <div class="bubble"></div>
        <div class="bubble"></div>
        <div class="bubble"></div>
        <div class="bubble"></div>
        <div class="bubble"></div>
        <div class="bubble"></div>
    </div>

    <div class="min-h-screen flex items-center justify-center px-4">
        <div class="login-card w-full max-w-md p-8">
            <div class="text-center mb-8">
                <div class="school-icon inline-flex items-center justify-center w-20 h-20 bg-indigo-100 rounded-full mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path d="M12 14l9-5-9-5-9 5 9 5z" />
                        <path d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l9-5-9-5-9 5 9 5zm0 0l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14zm-4 6v-7.5l4-2.222" />
                    </svg>
                </div>
                <h1 class="text-3xl font-bold text-gray-800">Welcome Back</h1>
                <p class="text-gray-600 mt-2">Sign in to your account</p>
            </div>
            
            <form id="loginForm">
                <div class="input-group">
                    <input type="text" id="username" placeholder=" " required>
                    <label for="username">Username</label>
                </div>
                
                <div class="input-group">
                    <input type="password" id="password" placeholder=" " required>
                    <label for="password">Password</label>
                </div>
                
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center">
                        <input id="remember-me" type="checkbox" class="h-4 w-4 text-indigo-600 focus:ring-indigo-500 border-gray-300 rounded">
                        <label for="remember-me" class="ml-2 block text-sm text-gray-700">Remember me</label>
                    </div>
                    
                    <div class="text-sm">
                        <a href="#" class="font-medium text-indigo-600 hover:text-indigo-500">Forgot password?</a>
                    </div>
                </div>
                
                <button type="submit" class="login-btn w-full">Sign In</button>
            </form>
            
            <div class="text-center mt-6">
                <p class="text-sm text-gray-600">Need help? <a href="#" class="font-medium text-indigo-600 hover:text-indigo-500">Contact support</a></p>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const loginForm = document.getElementById('loginForm');
            
            loginForm.addEventListener('submit', async function(e) {
                e.preventDefault();
                
                const username = document.getElementById('username').value;
                const password = document.getElementById('password').value;
                
                try {
                    const response = await fetch('https://edmapi.ed5.in/api/login.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            username: username,
                            password: password
                        })
                    });
                    
                    const data = await response.json();
                    
                    if (data.status === true) {
                        // Store token in localStorage
                        localStorage.setItem('auth_token', data.data.token);
                        localStorage.setItem('user_data', JSON.stringify(data.data.user));
                        
                        // Redirect to dashboard
                        window.location.href = 'dashboard.html';
                    } else {
                        alert('Login failed. Please check your credentials.');
                    }
                } catch (error) {
                    console.error('Error:', error);
                    alert('An error occurred during login. Please try again.');
                }
            });
        });
    </script>
</body>
</html>