<?php
// Set CORS headers - Keep only one set of CORS headers
header("Access-Control-Allow-Origin: https://edmpwa.ed5.in");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Max-Age: 3600");


// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    // Just exit with 200 OK status
    http_response_code(200);
    exit(0);
}

// Include database and user object
include_once '../config/Database.php';
include_once '../models/User.php';

// Get posted data
$data = json_decode(file_get_contents("php://input"));

// Validate input
if(!isset($data->username) || !isset($data->password)) {
    http_response_code(400);
    echo json_encode(array(
        "status" => false,
        "message" => "Incomplete data. Username and password are required."
    ));
    exit();
}

// Initialize database
$database = new Database();
$db = $database->getConnection();

// Initialize user
$user = new User($db);

// Login attempt
$result = $user->login($data->username, $data->password);

if($result['status']) {
    // Add roles to response
    $roles = $user->getUserRoles($result['data']['user']['id']);
    $result['data']['user']['roles'] = $roles;
    
    // Get current academic session
    $currentAcademicSession = getCurrentAcademicSession($db);
    $result['data']['current_academic_session'] = $currentAcademicSession;
    
    http_response_code(200);
} else {
    http_response_code(401);
}

echo json_encode($result);

/**
 * Get the current academic session
 * @param PDO $db Database connection
 * @return array|null Current academic session data or null if not found
 */
function getCurrentAcademicSession($db) {
    try {
        // Query to get the current/default academic session using is_default = 1
        $query = "SELECT id, name, description, start_date, end_date, options 
                  FROM academic_sessions 
                  WHERE is_default = 1 
                  LIMIT 1";
        
        $stmt = $db->prepare($query);
        $stmt->execute();
        
        if($stmt->rowCount() > 0) {
            return $stmt->fetch(PDO::FETCH_ASSOC);
        }
        
        // If no default session found, get the most recent one based on start date
        $query = "SELECT id, name, description, start_date, end_date, options 
                  FROM academic_sessions 
                  ORDER BY start_date DESC 
                  LIMIT 1";
                  
        $stmt = $db->prepare($query);
        $stmt->execute();
        
        if($stmt->rowCount() > 0) {
            return $stmt->fetch(PDO::FETCH_ASSOC);
        }
        
        return null;
    } catch(PDOException $e) {
        // Log error (in production)
        // error_log("Error fetching academic session: " . $e->getMessage());
        return null;
    }
}
?>