<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Allow CORS
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Capture all headers
$allHeaders = getallheaders();
$serverVars = $_SERVER;

// Create response
$response = [
    "message" => "Header Debug Information",
    "all_headers" => $allHeaders,
    "server_vars" => array_filter($serverVars, function($key) {
        return strpos($key, 'HTTP_') === 0 || in_array($key, ['REQUEST_METHOD', 'REQUEST_URI']);
    }, ARRAY_FILTER_USE_KEY),
    "php_sapi" => php_sapi_name(),
    "auth_header_found" => false,
    "possible_auth_headers" => []
];

// Check for different variants of Authorization header
foreach ($allHeaders as $name => $value) {
    if (strtolower($name) === 'authorization') {
        $response["auth_header_found"] = true;
        $response["possible_auth_headers"][$name] = $value;
    }
}

// Check if Authorization might be in $_SERVER
foreach ($serverVars as $key => $value) {
    if (strpos($key, 'HTTP_AUTHORIZATION') !== false || 
        strpos($key, 'HTTP_AUTH') !== false || 
        strpos($key, 'AUTHORIZATION') !== false || 
        strpos($key, 'AUTH') !== false) {
        $response["possible_auth_headers"][$key] = $value;
    }
}

// Check for Apache_request_headers function
if (function_exists('apache_request_headers')) {
    $response["apache_headers"] = apache_request_headers();
}

// Output the debug information
echo json_encode($response, JSON_PRETTY_PRINT);
?>